/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertPrincipal;
import com.ibm.hwmca.fw.certs.CertUtils;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.util.Trace;
import java.security.cert.X509Certificate;
import java.util.HashSet;

public class SelfSignedServerCert
extends ServerCert
implements CertMgtConstants {
    public static final int RETURN_OK = 0;
    public static final int RETURN_INVALID_NUM_OF_ARGS = 16;
    public static final int RETURN_EXCEPTION = 32;
    public static final int RETURN_INSUFFICIENT = 48;
    public static final int RETURN_EXTRANEOUS = 64;
    public static final int RETURN_UNKNOWN = 80;
    private static int INDEX_OF_LAST_FIXED_ARG = 11;
    private static final String TRACE_MASKD = "XCRTSSSD";
    private static final String TRACE_MASKF = "XCRTSSSF";
    private static final String TRACE_MASKT = "XCRTSSST";

    SelfSignedServerCert(int days, String country, String state, String locality, String org, String orgUnit, String hostName, String eMailAddr, HashSet alternateDNSNames, HashSet ipAddresses, boolean isForCA) {
        super(days, country, state, locality, org, orgUnit, hostName, eMailAddr, new CertPrincipal(country, state, locality, org, orgUnit, hostName, eMailAddr), alternateDNSNames, ipAddresses, isForCA);
        Trace.trace(TRACE_MASKT, "<->SelfSignedServerCert(" + days + ", " + country + ", " + state + ", " + locality + ", " + org + ", " + orgUnit + ", " + hostName + ", " + eMailAddr + ", ..., " + isForCA + ")");
    }

    SelfSignedServerCert(X509Certificate certificate) throws HException {
        super(certificate);
        Trace.trace(TRACE_MASKT, "<->SelfSignedServerCert(" + certificate + ")");
    }

    public static void main(String[] args) {
        int i;
        HashSet<String> alternateDNSNames = null;
        HashSet<String> IPAddresses = null;
        boolean isForCA = false;
        boolean removePassPhrase = false;
        String passPhrase = null;
        String eMailAddr = null;
        StringBuffer argsLine = new StringBuffer();
        for (int i2 = 0; i2 < args.length; ++i2) {
            argsLine.append(' ');
            argsLine.append(args[i2]);
        }
        Trace.trace(TRACE_MASKD, "main() called with the following parameters :" + argsLine.toString());
        if (args.length < INDEX_OF_LAST_FIXED_ARG + 1) {
            SelfSignedServerCert.displayHelp();
            CertUtils.doExit(48 + args.length + 1);
        }
        for (i = 0; i < args.length; ++i) {
            args[i] = args[i].replaceAll("0x20", " ");
        }
        alternateDNSNames = new HashSet<String>();
        IPAddresses = new HashSet<String>();
        for (i = INDEX_OF_LAST_FIXED_ARG + 1; i < args.length; ++i) {
            if (CertUtils.isIPAddress(args[i])) {
                IPAddresses.add(args[i]);
                continue;
            }
            alternateDNSNames.add(args[i]);
        }
        if (!args[9].equalsIgnoreCase("NULL")) {
            eMailAddr = args[9];
        }
        if (args[10].equalsIgnoreCase("true")) {
            isForCA = true;
        }
        if (args[11].equalsIgnoreCase("true")) {
            removePassPhrase = true;
        }
        try {
            passPhrase = new SelfSignedServerCert(Integer.parseInt(args[0]), args[3], args[4], args[5], args[6], args[7], args[8], eMailAddr, alternateDNSNames, IPAddresses, isForCA).writeToFile(args[1], args[2], removePassPhrase);
            if (!removePassPhrase) {
                System.err.println("The passphrase of the server key file " + args[2] + " is " + passPhrase + ".");
            }
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKD, e);
            e.printStackTrace();
            CertUtils.doExit(32);
        }
        CertUtils.doExit(0);
    }

    private static void displayHelp() {
        System.out.println("Usage : 'java' 'com.ibm.hwmca.fw.certs.SelfSignedServerCert' daysValid serverCertFile");
        System.out.println("          serverKeyFile country state locality org orgUnit hostName eMailAddr isForCA removePassPhrase");
        System.out.println("          [altDNSName | altIPAddress]...");
        System.out.println("");
        System.out.println("daysValid is the number of days that the certificate will be valid for.");
        System.out.println("serverCertFile is the fully qualified name of the server certificate file to create.");
        System.out.println("serverKeyFile is the fully qualified name of the server key file to create.");
        System.out.println("country the two letter country code (e.g. US).");
        System.out.println("state the state or province (e.g. CA).");
        System.out.println("locality the locality (e.g. Los Angeles).");
        System.out.println("org the organization (e.g. IBM).");
        System.out.println("orgUnit the organization unit (e.g. HMC).");
        System.out.println("hostName the fully qualified host name of the server for which the certificate is requested.");
        System.out.println("eMailAddr the email address of the self-signed certificate; 'NULL' if none should be added to");
        System.out.println("  the certificate.");
        System.out.println("isForCA 'true' if the certificate will be used by a CA, anything else if not.");
        System.out.println("removePassPhrase remove the passphrase from the resulting server key file to create if");
        System.out.println(" this argument is specified as 'true'; do not remove the passphrase and write it to");
        System.out.println(" to stdout otherwise.");
        System.out.println("altDNSName is a DNS name, other than the fully qualified host name, by which the host");
        System.out.println("  is known. The name(s) will be added to the certificate in the subjectAltName field.");
        System.out.println("altIPAddress is an IP address by which the host is known. The address(es) will be");
        System.out.println("  added to the certificate in the subjectAltName field.");
        System.out.println("");
        System.out.println("An exit status code other than 0 indicates an error.");
        System.out.println("");
        System.out.println("Any substring, found within an argument, to be equal to \"0x20\" (without the quotes),");
        System.out.println("will be replaced with a space character. This is to allow blanks to be embedded in");
        System.out.println("the arguments if needed. Yes, I know this is a hack but time is money.");
        System.out.println("");
        System.out.println("The above command syntax above uses the following conventions:");
        System.out.println("");
        System.out.println("Literal tokens in the specified command are denoted by being enclosed in single quotes.");
        System.out.println("When specified, the single quotes should not be specified.");
        System.out.println("");
        System.out.println("Tokens that are not literal tokens should be replaced with the appropriate value.");
        System.out.println("");
        System.out.println("Tokens that are optional are enclosed in square brackets. If more than one token is");
        System.out.println("included and separated by a vertical bar, you can chose one or none of the tokens.");
        System.out.println("Neither the square brackets or vertical bars should be specified on the command.");
        System.out.println("");
        System.out.println("If there are multiple token choices but one is required, the tokens are enclosed in");
        System.out.println("braces and separated by a vertical bar.");
        System.out.println("Neither the braces or vertical bars should be specified on the command.");
        System.out.println("");
        System.out.println("If a token or group of tokens, grouped by square brackets or braces, can be repeated,");
        System.out.println("a sequence of three periods will follow the token or token group.");
    }
}

